 /******************************************************************************
 *
 *	   A U T O   A C C E L E R O M E T E R    M A I N   P R O G R A M 
 *
 */
#pragma config  FOSC = IRC, PLLEN = OFF, PCLKEN = OFF, IESO = OFF, FCMEN = OFF, HFOFST = OFF, LVP = OFF, WDTEN = OFF
#include "accel.h"
#include "display.h"
#include "p18lf14k22.h"

void main(void)
{
	uchar event;
	float theta, phi, rho;
	float thetaraw, thetaoffset;
	
	// Configure System
	OSCCONbits.IDLEN = 0;					// SLEEP instruction enters sleep
	OSCCONbits.IRCF = 7;					// 16 MHz Clock
	OSCCONbits.SCS = 2;						// Primary clock only
	ANSEL = 0b00000000;                     // No analogue inputs
	RCONbits.IPEN = 1;						// Two-level interrupt priority
	INTCONbits.GIEH = 1;					// Enable hi-priority ints
	INTCONbits.GIEL = 1;					// Enable lo-priority interrupts
	
	// Initialise drivers
	accInitialise();
	
	// Configure Acceleromemeter	
	accSet(F_SETUP, 0);						// FIFO disabled
	accSet(XYZ_DATA_CFG, 0x00);				// 2g, HPF disabled
	accSet(HP_FILTER_CUTOFF, 0x01); 		// 1.0Hz
	accSet(CTRL_REG1, 0xb0);				// 2-byte read, 6.25 Hz awake & asleep
	accSet(CTRL_REG2, 0x18);				// Normal res awake & asleep, no auto sleep
	accSet(CTRL_REG3, 0x00);				// Int PP, active lo, no wake-up
	accSet(CTRL_REG4, 0x01);				// Data rdy int enabled
	accSet(CTRL_REG5, 0x01);				// Data rdy int ->int1, rest -> int2
	
	
	accStart();
		
	// Loop forever
	while(1);	
}	
					
/**********************************************************************
 *     Interrupt service routine - low
 */
#pragma interruptlow isrlo 
void isrlo(void)
{	
	if(INTCON3bits.INT1IF == 1){  	// accelerometer INT1
		INTCON3bits.INT1IF = 0;
		accInt1isr();
	}

	else if(INTCONbits.RABIF == 1){		// accelerometer Cal Button
		INTCONbits.RABIF = 0;
		accCalisr();
	}	
}
/**********************************************************************
 *     Interrupt service routine - high
 */                                
#pragma interrupt isrhi nosave=FSR0, TBLPTRL, TBLPTRH, TBLPTRU, TABLAT, PCLATH, PCLATU, PROD, section(".tmpdata"), section("MATH_DATA")
void isrhi(void)
{
	if(INTCONbits.TMR0IF == 1){		// Timer 0 interrupt
		INTCONbits.TMR0IF = 0;	
		dispMux();	
	}
	if(PIR1bits.SSPIF == 1){		// I2C interrupt
		PIR1bits.SSPIF = 0;	
		i2cStateMachine();
	}		
}
#pragma	code

#pragma code invectlo = 0x18
void intvectlo(void)
{
   _asm goto isrlo  _endasm
}
#pragma code

#pragma code intvecthi = 0x08
void intvecthi(void)
{
   _asm goto isrhi  _endasm
}